﻿using Tessa.Cards;
using Tessa.Cards.Extensions;
using Tessa.Roles;
using Unity;
using Unity.Lifetime;

namespace Tessa.Extensions.AclExamples.Server.Roles
{
    [Registrator]
    public sealed class Registrator : RegistratorBase
    {
        #region Base Overrides

        public override void RegisterUnity()
        {
            this.UnityContainer
                .RegisterType<IDepartmentSettingsDocTypesProvider, DepartmentSettingsDocTypesProvider>(new ContainerControlledLifetimeManager())
                
                .RegisterType<DepartmentRoleCardStoreExtension>(new ContainerControlledLifetimeManager())
                ;
        }

        public override void RegisterExtensions(IExtensionContainer extensionContainer)
        {
            extensionContainer

                // Store
                .RegisterExtension<ICardStoreExtension, DepartmentRoleCardStoreExtension>(x => x
                    .WithOrder(ExtensionStage.BeforePlatform, 0)
                    .WithUnity(this.UnityContainer)
                    .WhenCardTypes(RoleHelper.DepartmentRoleTypeID))
                ;
        }

        #endregion
    }
}
