﻿using Tessa.Cards;
using Tessa.Cards.Extensions;
using Tessa.Extensions.AclExamples.Shared;
using Tessa.Roles;
using Tessa.Roles.Acl;
using Unity;
using Unity.Lifetime;

namespace Tessa.Extensions.AclExamples.Server.Cards
{
    [Registrator]
    public class Registrator : RegistratorBase
    {
        #region Base Overrides

        public override void RegisterUnity()
        {
            this.UnityContainer
                .RegisterType<ICardStoreExtension, DepartmentRoleStoreExtension>(new ContainerControlledLifetimeManager())
                .RegisterType<ICardStoreExtension, MeetingProtocolCardStoreExtension>(new ContainerControlledLifetimeManager())

                .RegisterType<AeAuthorAclGenerationRule>(new ContainerControlledLifetimeManager())
                .RegisterType<IAclGenerationRuleProvider, AeAclGenerationRuleProvider>("AclExamples", new ContainerControlledLifetimeManager())
                ;
        }

        public override void RegisterExtensions(IExtensionContainer extensionContainer)
        {
            extensionContainer

                // Store
                .RegisterExtension<ICardStoreExtension, DepartmentRoleStoreExtension>(x => x
                    .WithOrder(ExtensionStage.BeforePlatform, 0)
                    .WithUnity(this.UnityContainer)
                    .WhenCardTypes(RoleHelper.DepartmentRoleTypeID))
                .RegisterExtension<ICardStoreExtension, MeetingProtocolCardStoreExtension>(x => x
                    .WithOrder(ExtensionStage.BeforePlatform, 1)
                    .WithUnity(this.UnityContainer)
                    .WhenCardTypes(AclExamplesCardTypes.AclMeetingProtocolTypeID))
                ;
        }

        #endregion
    }
}
