﻿// Проверяем, было ли уже отправлено основное задания для данной экспертизы
if (Process.TaskID != Guid.Empty)
{
	// Если есть задание, то переносим строки секции с исполнителями в новое задание
	var prevTask = await Context.GetTaskAsync((Guid)Process.TaskID);
	if (prevTask != null)
	{
		var prevEmpSection = prevTask.Card.Sections["WfeTaskTasksEmployee"];
		var empSection = task.Card.Sections["WfeTaskTasksEmployee"];
		foreach(var row in prevEmpSection.Rows)
		{
			var newRow = empSection.Rows.Add(row);
			newRow.State = CardRowState.Inserted;
			newRow.RowID = Guid.NewGuid();
		}
	}
}

// Заполняем параметры задания из настроек сигнала и процесса
Process.TaskID = task.RowID;
task.TaskAssignedRoles.RemoveAll(x => x.TaskRoleID == CardFunctionRoles.PerformerID);
task.AddPerformer((Guid)Signal.RoleID, (string)Signal.RoleName);
task.Card.DynamicEntries.WfeTasksCommonInfo.ExpertDepartmentID = Process.DepartmentID;

task.ParentRowID = (Guid)Process.MainTaskID;
task.HistoryItemParentRowID = (Guid)Process.MainTaskID;

await FillDigestWithCommentAsync(task);