﻿using System;
using System.Linq;
using System.Threading.Tasks;
using Tessa.Cards;
using Tessa.Cards.Extensions;
using Tessa.Platform.Storage;

namespace Tessa.Extensions.WorkflowExamples.Server.Workflow
{
    public sealed class WfeGetTaskExtension : CardGetExtension
    {
        #region Base Overrides

        public override Task AfterRequest(ICardGetExtensionContext context)
        {
            if (!context.RequestIsSuccessful
                || !context.Response.Card.Sections.TryGetValue("WfeExpertiseStatistics", out var expertiseCardSection))
            {
                return Task.CompletedTask;
            }

            var expertiseRows = expertiseCardSection.Rows;
            foreach(var task in context.Response.Card.Tasks)
            {
                if (task.Card.Sections.TryGetValue("WfeTaskRequestedExpertiseVirtual", out var expertiseSection))
                {
                    foreach(var row in expertiseRows.Where(x => x.Get<Guid>("ParentRowID") == task.RowID))
                    {
                        var taskRow = expertiseSection.Rows.Add();
                        taskRow.RowID = Guid.NewGuid();
                        taskRow["ResultRowID"] = row.TryGet<Guid?>("ResultRowID");
                        taskRow["ResultResultName"] = row.TryGet<string>("ResultResultName");
                        taskRow["DepartmentID"] = row.TryGet<Guid>("DepartmentsID");
                        taskRow["DepartmentName"] = row.TryGet<string>("DepartmentsName");
                        taskRow["Comment"] = row.TryGet<string>("Comment");
                        taskRow["CommentLimit"] = row.TryGet<string>("CommentLimit");
                        taskRow["State"] = taskRow["ResultRowID"] != null ? "Завершено" : "В работе";
                        taskRow.State = CardRowState.None;
                    }
                }
            }

            return Task.CompletedTask;
        }

        #endregion
    }
}
