﻿using System;
using Tessa.Cards;
using Tessa.Cards.Extensions;
using Tessa.Extensions.Default.Server.Workflow.KrPermissions;
using Tessa.Extensions.WorkflowExamples.Shared.Workflow;
using Tessa.Workflow.Actions;
using Tessa.Workflow.Compilation;
using Unity;
using Unity.Lifetime;

namespace Tessa.Extensions.WorkflowExamples.Server.Workflow
{
    [Registrator]
    public sealed class Registrator : RegistratorBase
    {

        public override void FinalizeRegistration()
        {
            this.UnityContainer.Resolve<IWorkflowEngineCompiledBaseRegistry>()
                .Register<WfeCompiledBase>(new Guid(0x8555B8AA, 0xA035, 0x45F8, 0xB2, 0x16, 0x0F, 0x96, 0xD4, 0x43, 0xD0, 0x7E), "Тестовый базовый класс") // 8555B8AA-A035-45F8-B216-0F96D443D07E
                ;
        }

        public override void RegisterUnity()
        {
            this.UnityContainer
                .RegisterType<WfeLoanStoreExtension>(new ContainerControlledLifetimeManager())
                .RegisterType<IWorkflowAction, WfeLoanSetStateAction>(nameof(WfeLoanSetStateAction), new ContainerControlledLifetimeManager())
                .RegisterType<WfTasksServerGetExtension>(new ContainerControlledLifetimeManager());
        }

        public override void RegisterExtensions(IExtensionContainer extensionContainer)
        {
            extensionContainer
                .RegisterExtension<ICardStoreExtension, WfeLoanStoreExtension>(x => x
                    .WithOrder(ExtensionStage.BeforePlatform)
                    .WithUnity(this.UnityContainer)
                    .WhenCardTypes(WfeHelper.WfeLoanApprovalTypeID))
                .RegisterExtension<ICardStoreTaskExtension, WfeStoreTaskExtension>(x => x
                    .WithOrder(ExtensionStage.BeforePlatform)
                    .WithSingleton()
                    .WhenTaskTypes(WfeHelper.ExpertiseInDepartmentAppointExecutiveTypeID))
                .RegisterExtension<ICardGetExtension, WfeGetTaskExtension>(x => x
                    .WithOrder(ExtensionStage.BeforePlatform)
                    .WithSingleton()
                    .WhenTaskTypes(WfeHelper.WfeLoanApprovalTypeID))
                .RegisterExtension<ICardGetExtension, WfTasksServerGetExtension>(x => x
                    .WithOrder(ExtensionStage.BeforePlatform)
                    .WithUnity(this.UnityContainer)
                    .WhenMethod(CardGetMethod.Default, CardGetMethod.Backup, CardGetMethod.Export))

                .RegisterExtension<ITaskPermissionsExtension, WfeTaskPermissionExtension>(x => x
                    .WithOrder(ExtensionStage.AfterPlatform, 1)
                    .WithSingleton())
                ;
        }
    }
}