﻿using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace Tessa.Extensions.WorkflowExamples.Shared.Roles
{
    /// <summary>
    /// Стратегия агрегации ролей.
    /// </summary>
    public interface IRolesFormationStrategy
    {
        /// <summary>
        /// Производит агрегацию ролей.
        /// </summary>
        /// <param name="cardID">Идентификатор карточки.</param>
        /// <param name="roles">Список ролей.</param>
        /// <param name="cancellationToken">Объект, посредством которого можно отменить асинхронную операцию.</param>
        /// <returns>Агрегирующая роль.</returns>
        ValueTask<(Guid ID, string Name)> GetRolesFormationAsync(
            Guid cardID,
            Dictionary<Guid, string> roles,
            CancellationToken cancellationToken = default);
    }
}
