﻿using System;
using System.Threading.Tasks;
using Tessa.Cards;
using Tessa.Cards.Extensions;
using Tessa.Extensions.WorkflowExamples.Shared.Workflow;
using Tessa.Platform.Storage;

namespace Tessa.Extensions.WorkflowExamples.Server.Workflow
{
    public class WfeStoreTaskExtension : CardStoreTaskExtension
    {
        public override Task StoreTaskBeforeRequest(ICardStoreTaskExtensionContext context)
        {
            if (context.Task.TypeID == WfeHelper.ExpertiseInDepartmentAppointExecutiveTypeID)
            {
                StringDictionaryStorage<CardSection> sections;
                if ((sections = context.Task.TryGetCard().TryGetSections()) != null)
                {
                    sections.TryGetValue("WfeTasksCommonInfo", out CardSection cardSection);

                    if (cardSection == null)
                    {
                        return Task.CompletedTask;
                    }

                    if (cardSection.Fields.TryGet<bool?>("IsSendSubtask") ?? false)
                    {
                        Guid? optionID = context.Task.OptionID;
                        if (optionID == WfeCompletionOptions.AppointExecutive)
                        {
                            if (context.Task.State == CardRowState.Deleted)
                            {
                                context.Task.State = CardRowState.Modified;
                            }
                        }
                    }
                }
            }

            return Task.CompletedTask;
        }
    }
}
