﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using Tessa.Extensions.Default.Shared.Workflow.KrProcess;
using Tessa.Platform;

namespace Tessa.Extensions.AclExamples.Server.Roles
{
    /// <summary>
    /// Реализация <see cref="IDepartmentSettingsDocTypesProvider"/>, которая возвращает все типы карточек и типы документов, добавленные в типовое решение.
    /// </summary>
    public sealed class DepartmentSettingsDocTypesProvider : IDepartmentSettingsDocTypesProvider
    {
        #region Fields

        private readonly IKrTypesCache krTypesCache;

        #endregion

        #region Constructors

        public DepartmentSettingsDocTypesProvider(
            IKrTypesCache krTypesCache)
        {
            Check.ArgumentNotNull(krTypesCache, nameof(krTypesCache));

            this.krTypesCache = krTypesCache;
        }

        #endregion

        #region IDepartmentSettingsDocTypesProvider Implementation

        ///<inheritdoc/>
        public async ValueTask<IList<(Guid, string)>> GetAllDocTypesAsync(CancellationToken cancellationToken = default)
        {
            var types = await this.krTypesCache.GetTypesAsync(cancellationToken);

            return types.Select(x => (x.ID, x.Caption)).ToArray();
        }

        #endregion
    }
}
