﻿using System;

namespace Tessa.Extensions.WorkflowExamples.Shared.Workflow
{
    /// <summary>
    /// Варианты заврешения задания используемые в примерах.
    /// </summary>
    public static class WfeCompletionOptions
    {
        /// <summary>
        /// Отказ.
        /// </summary>
        public static readonly Guid Renouncement =          // {79E00576-0C90-49A7-A62E-5791A86A3750}
            new Guid(0x79e00576, 0xc90, 0x49a7, 0xa6, 0x2e, 0x57, 0x91, 0xa8, 0x6a, 0x37, 0x50);

        /// <summary>
        /// Запросить экспертизу.
        /// </summary>
        public static readonly Guid RequestExpertise =      // {CB133099-AC37-4FD9-8250-69FE96FFB0C6}
            new Guid(0xcb133099, 0xac37, 0x4fd9, 0x82, 0x50, 0x69, 0xfe, 0x96, 0xff, 0xb0, 0xc6);

        /// <summary>
        /// Экспертиза проведена.
        /// </summary>
        public static readonly Guid ExpertiseConducted =    // {DED715D5-A66F-4053-85B7-03C3BADEB774}
            new Guid(0xded715d5, 0xa66f, 0x4053, 0x85, 0xb7, 0x3, 0xc3, 0xba, 0xde, 0xb7, 0x74);

        /// <summary>
        /// Выбрать исполнителя.
        /// </summary>
        public static readonly Guid AppointExecutive =      // {C55F7870-0CA6-4F70-9BC1-190BB345FB13}
            new Guid(0xc55f7870, 0xca6, 0x4f70, 0x9b, 0xc1, 0x19, 0xb, 0xb3, 0x45, 0xfb, 0x13);

        /// <summary>
        /// Передать.
        /// </summary>
        public static readonly Guid ChangeExecutive =  // {8316A253-BB1D-44E6-B0D0-33DED86D4B24}
            new Guid(0x8316a253, 0xbb1d, 0x44e6, 0xb0, 0xd0, 0x33, 0xde, 0xd8, 0x6d, 0x4b, 0x24);

        /// <summary>
        /// Далее.
        /// </summary>
        public static readonly Guid Next =             // {0D79876C-25AE-4775-8F7F-F7375E2C128D}
            new Guid(0xd79876c, 0x25ae, 0x4775, 0x8f, 0x7f, 0xf7, 0x37, 0x5e, 0x2c, 0x12, 0x8d);

        /// <summary>
        /// На запрос экспертиз.
        /// </summary>
        public static readonly Guid OnRequestExpertise = // {A3BE8FBA-8D49-4CEE-94FD-D39C2AC0CC28}
            new Guid(0xa3be8fba, 0x8d49, 0x4cee, 0x94, 0xfd, 0xd3, 0x9c, 0x2a, 0xc0, 0xcc, 0x28);

        /// <summary>
        /// На проведение анализа.
        /// </summary>
        public static readonly Guid OnAnalysis = // {8E48CF27-7284-4A27-BF05-25F1C32F10CD}
            new Guid(0x8e48cf27, 0x7284, 0x4a27, 0xbf, 0x5, 0x25, 0xf1, 0xc3, 0x2f, 0x10, 0xcd);

        /// <summary>
        /// Доработка заявки.
        /// </summary>
        public static readonly Guid OnRevision = // {274938B9-A07E-4805-81B8-B85854051A0E}
            new Guid(0x274938b9, 0xa07e, 0x4805, 0x81, 0xb8, 0xb8, 0x58, 0x54, 0x5, 0x1a, 0xe);

        /// <summary>
        /// Запросить консультацию.
        /// </summary>
        public static readonly Guid RequestСonsultation =  // {1B84DA1D-17BE-4B1D-A689-2DF00E060DB5}
            new Guid(0x1b84da1d, 0x17be, 0x4b1d, 0xa6, 0x89, 0x2d, 0xf0, 0xe, 0x6, 0xd, 0xb5);

        /// <summary>
        /// Консультация проведена.
        /// </summary>
        public static readonly Guid СonsultationСonducted = // {1DC13768-CEB6-474A-BEC2-C021251FDE73}
            new Guid(0x1dc13768, 0xceb6, 0x474a, 0xbe, 0xc2, 0xc0, 0x21, 0x25, 0x1f, 0xde, 0x73);

        /// <summary>
        /// Завершить процесс.
        /// </summary>
        public static readonly Guid CompleteProcess = // {66C06E5E-0C92-4FFF-B619-1574FE25DB39}
            new Guid(0x66c06e5e, 0xc92, 0x4fff, 0xb6, 0x19, 0x15, 0x74, 0xfe, 0x25, 0xdb, 0x39);

        /// <summary>
        /// Клиент согласен.
        /// </summary>
        public static readonly Guid ClientAgrees =   // {7CC4A790-D3E1-4AD3-A5C6-B1894C1AEC95}
            new Guid(0x7cc4a790, 0xd3e1, 0x4ad3, 0xa5, 0xc6, 0xb1, 0x89, 0x4c, 0x1a, 0xec, 0x95);

        /// <summary>
        /// На рассмотрение КК
        /// </summary>
        public static readonly Guid ReviewOfKK = // {945B079E-CD79-48F2-BC47-F717BCB557DF}
            new Guid(0x945b079e, 0xcd79, 0x48f2, 0xbc, 0x47, 0xf7, 0x17, 0xbc, 0xb5, 0x57, 0xdf);

        /// <summary>
        /// Положительное решение.
        /// </summary>
        public static readonly Guid PositiveDecision = // {5C372050-8CF1-458E-AD76-D00ED57C8789}
            new Guid(0x5c372050, 0x8cf1, 0x458e, 0xad, 0x76, 0xd0, 0xe, 0xd5, 0x7c, 0x87, 0x89);

        /// <summary>
        /// Отрицательное решение.
        /// </summary>
        public static readonly Guid NegativeDecision = // {2AC04B17-C891-42A0-B1BB-FEF52BA76F02}
            new Guid(0x2ac04b17, 0xc891, 0x42a0, 0xb1, 0xbb, 0xfe, 0xf5, 0x2b, 0xa7, 0x6f, 0x2);

        /// <summary>
        /// Отозвано инициатором.
        /// </summary>
        public static readonly Guid RevokedInitiator =  // {C745FC50-508D-4D80-9F09-A040B92787F4}
            new Guid(0xc745fc50, 0x508d, 0x4d80, 0x9f, 0x9, 0xa0, 0x40, 0xb9, 0x27, 0x87, 0xf4);

        /// <summary>
        /// Отправить запрос.
        /// </summary>
        public static readonly Guid SendRequest =  // {51A04490-F4CC-4AF5-BEEA-D34733155257}
            new Guid(0x51a04490, 0xf4cc, 0x4af5, 0xbe, 0xea, 0xd3, 0x47, 0x33, 0x15, 0x52, 0x57);

        /// <summary>
        /// Ответить.
        /// </summary>
        public static readonly Guid SendAnswer =  // {8A603CCB-A7CC-4900-B975-23F353FC44F9}
            new Guid(0x8a603ccb, 0xa7cc, 0x4900, 0xb9, 0x75, 0x23, 0xf3, 0x53, 0xfc, 0x44, 0xf9);
    }
}
