﻿#nullable enable

using System.Threading.Tasks;
using Tessa.Cards;
using Tessa.Cards.Extensions;
using Tessa.Platform.Storage;

namespace Tessa.Extensions.WorkflowExamples.Server.Cards
{
    internal class WfeLoanApprovalCopyCardNewExtension : CardNewGetExtension
    {
        #region Private Methods

        private static void ClearProcesFields(Card card)
        {
            var wfeLaCommonInfoSection = card.Sections["WfeLACommonInfo"];

            // Очистка в блоке "Процесс"
            wfeLaCommonInfoSection.RawFields["ProcessStepID"] = null;
            wfeLaCommonInfoSection.RawFields["ProcessStepName"] = null;
            wfeLaCommonInfoSection.RawFields["ProcessStagesID"] = null;
            wfeLaCommonInfoSection.RawFields["ProcessStagesName"] = null;

            // Очистка в блоке "Даты"
            wfeLaCommonInfoSection.RawFields["StageDataSart"] = null;
            wfeLaCommonInfoSection.RawFields["StagePlaneDataFinish"] = null;
            wfeLaCommonInfoSection.RawFields["ResolutionDate"] = null;

            // Очистка в блоке "Отказ"
            wfeLaCommonInfoSection.RawFields["StepRenouncementID"] = null;
            wfeLaCommonInfoSection.RawFields["StepRenouncementName"] = null;
            wfeLaCommonInfoSection.RawFields["CauseRenouncementRefID"] = null;
            wfeLaCommonInfoSection.RawFields["CauseRenouncementRefName"] = null;
            wfeLaCommonInfoSection.RawFields["CauseRenouncementCom"] = null;

            // Очистка в блоке "Связанная заявка"
            wfeLaCommonInfoSection.RawFields["ConnectedStatementID"] = null;
            wfeLaCommonInfoSection.RawFields["ConnectedStatementFullNumber"] = null;

            // Очистка в блоке "Статистика по этапам"
            var wfeStagesStatisticsSection = card.Sections["WfeStagesStatistics"];
            wfeStagesStatisticsSection.Rows.Clear();

            // Очистка в блоке "Статистика по экспертизам"
            var wfeExpertiseStatisticsSection = card.Sections["WfeExpertiseStatistics"];
            wfeExpertiseStatisticsSection.Rows.Clear();
        }

        #endregion

        #region Base Overrides

        public override Task AfterRequest(ICardNewExtensionContext context)
        {
            if (!context.RequestIsSuccessful
                || (context.Method == CardNewMethod.Template
                    && !context.Request.Info.TryGet<bool>(CardHelper.CopyingCardKey)))
            {
                return Task.CompletedTask;
            }

            ClearProcesFields(context.Response!.Card);

            return Task.CompletedTask;
        }

        #endregion
    }
}
