﻿#using Tessa.Extensions.WorkflowExamples.Shared.Workflow
#using Tessa.Roles
#reference Tessa.Extensions.WorkflowExamples.Shared.dll

Process.MainTaskID = Signal.TaskIDs[0];
var depID = (Guid)Signal.ExpertDepartmentID;
var segmentID = (int)Signal.Segment;

// Метод для получения настроек экспертного подразделения из базы. 
// Вынесен в Helper в расширениях для простоты использования
var info = await WfeWorkflowHelper.GetTaskInfoForDepartmentAsync(DbScope, depID, segmentID);

Process.Digest = info.Item1;
Process.Period = info.Item3 / 8.0;
Process.DepartmentID = depID;

// GetRolesFormationAsync - Метод для агрегации ролей, указанных как исполнители экспертного подразделения
// GetRoleByDepartmentAsync - Метод для получения исполнителей экспертного подразделения
var role = await WfeWorkflowHelper.GetRolesFormationAsync(
	await WfeWorkflowHelper.GetRoleByDepartmentAsync(DbScope, depID, segmentID),
	Container.Resolve<IRoleRepository>(),
	CardID);

Signal.RoleID = role.Item1;
Signal.RoleName = role.Item2;

// Метод старта экспертизы. Производит первичную запись в основную карточку
Process.ExpertiseID = await WfeWorkflowHelper.StartExpertiseAsync(
	Context,
	(Guid)Process.MainTaskID,
	depID,
	info.Item2,
	info.Item3);
	