﻿using System;
using Tessa.Workflow.Actions.Descriptors;

namespace Tessa.Extensions.WorkflowExamples.Shared.Workflow
{
    public static class WfeHelper
    {
        #region CardTypes

        /// <summary>
        /// Card type identifier for "WfeLoanApproval": {46E42560-0633-4EF1-85F9-6E5BCCE20C7C}.
        /// </summary>
        public static readonly Guid WfeLoanApprovalTypeID = new Guid(0x46e42560, 0x0633, 0x4ef1, 0x85, 0xf9, 0x6e, 0x5b, 0xcc, 0xe2, 0x0c, 0x7c);

        /// <summary>
        /// Card type name for "WfeLoanApproval".
        /// </summary>
        public const string WfeLoanApprovalTypeName = "WfeLoanApproval";

        /// <summary>
        /// Card type identifier for "WfeLoanSetStateAction": {815CA020-E783-4B67-B7ED-5E660D9AF919}.
        /// </summary>
        public static readonly Guid WfeLoanSetStateActionTypeID = new Guid(0x815ca020, 0xe783, 0x4b67, 0xb7, 0xed, 0x5e, 0x66, 0x0d, 0x9a, 0xf9, 0x19);

        /// <summary>
        /// Card type name for "WfeLoanSetStateAction".
        /// </summary>
        public const string WfeLoanSetStateActionTypeName = "WfeLoanSetStateAction";

        #endregion

        #region Task Types

        /// <summary>
        /// Task type identifier for "ExpertiseInDepartmentAppointExecutive": {978E8DEE-0A3F-44AF-B361-A7C8F7BF7A5A}.
        /// </summary>
        public static readonly Guid ExpertiseInDepartmentAppointExecutiveTypeID = new Guid(0x978e8dee, 0x0a3f, 0x44af, 0xb3, 0x61, 0xa7, 0xc8, 0xf7, 0xbf, 0x7a, 0x5a);

        /// <summary>
        /// Task type name for "ExpertiseInDepartmentAppointExecutive".
        /// </summary>
        public const string ExpertiseInDepartmentAppointExecutiveTypeName = "ExpertiseInDepartmentAppointExecutive";


        /// <summary>
        /// Task type identifier for "CorrectionRequest": {215DEFAA-03D2-43EF-BF59-0567DBC6806E}.
        /// </summary>
        public static readonly Guid CorrectionRequestTypeID = new Guid(0x215defaa, 0x03d2, 0x43ef, 0xbf, 0x59, 0x05, 0x67, 0xdb, 0xc6, 0x80, 0x6e); //12

        /// <summary>
        /// Task type name for "CorrectionRequest".
        /// </summary>
        public const string CorrectionRequestTypeName = "CorrectionRequest";


        /// <summary>
        /// Task type identifier for "ExpressAnalysis": {9A6FCB61-85E5-4712-9FB6-356639799CC2}.
        /// </summary>
        public static readonly Guid ExpressAnalysisTypeID = new Guid(0x9a6fcb61, 0x85e5, 0x4712, 0x9f, 0xb6, 0x35, 0x66, 0x39, 0x79, 0x9c, 0xc2); //21

        /// <summary>
        /// Task type name for "ExpressAnalysis".
        /// </summary>
        public const string ExpressAnalysisTypeName = "ExpressAnalysis";

        /// <summary>
        /// Task type identifier for "ConductingExpresAnalysis": {D32F243F-E2BA-4C0D-AF0F-5FBCA9E52917}.
        /// </summary>
        public static readonly Guid ConductingExpresAnalysisTypeID = new Guid(0xd32f243f, 0xe2ba, 0x4c0d, 0xaf, 0x0f, 0x5f, 0xbc, 0xa9, 0xe5, 0x29, 0x17); //22

        /// <summary>
        /// Task type name for "ConductingExpresAnalysis".
        /// </summary>
        public const string ConductingExpresAnalysisTypeName = "ConductingExpresAnalysis";

        /// <summary>
        /// Task type identifier for "RequestExpertise": {EB629765-39D3-4435-B8E2-E19B22D551D7}.
        /// </summary>
        public static readonly Guid RequestExpertiseTypeID = new Guid(0xeb629765, 0x39d3, 0x4435, 0xb8, 0xe2, 0xe1, 0x9b, 0x22, 0xd5, 0x51, 0xd7); //31

        /// <summary>
        /// Task type name for "RequestExpertise".
        /// </summary>
        public const string RequestExpertiseTypeName = "RequestExpertise";

        /// <summary>
        /// Task type identifier for "ProjectApproval": {6B315EA4-4F61-4661-B7F3-FB0DE1C476C4}.
        /// </summary>
        public static readonly Guid ProjectApprovalTypeID = new Guid(0x6b315ea4, 0x4f61, 0x4661, 0xb7, 0xf3, 0xfb, 0x0d, 0xe1, 0xc4, 0x76, 0xc4);

        /// <summary>
        /// Task type name for "ProjectApproval".
        /// </summary>
        public const string ProjectApprovalTypeName = "ProjectApproval";

        /// <summary>
        /// Task type identifier for "ExpertiseInDepartment": {10CBA188-40C1-48C0-B73C-9E141FEF9793}.
        /// </summary>
        public static readonly Guid ExpertiseInDepartmentTypeID = new Guid(0x10cba188, 0x40c1, 0x48c0, 0xb7, 0x3c, 0x9e, 0x14, 0x1f, 0xef, 0x97, 0x93);   //33

        /// <summary>
        /// Task type name for "ExpertiseInDepartment".
        /// </summary>
        public const string ExpertiseInDepartmentTypeName = "ExpertiseInDepartment";


        /// <summary>
        /// Task type identifier for "RequestDocument": {B252C8CE-1636-4308-86BE-674452A63304}.
        /// </summary>
        public static readonly Guid RequestDocumentTypeID = new Guid(0xb252c8ce, 0x1636, 0x4308, 0x86, 0xbe, 0x67, 0x44, 0x52, 0xa6, 0x33, 0x04); //34

        /// <summary>
        /// Task type name for "RequestDocument".
        /// </summary>
        public const string RequestDocumentTypeName = "RequestDocument";


        /// <summary>
        /// Task type identifier for "ConductingRiskSelectEmployee": {9317FDE2-AA52-4B0A-B47B-125583E85347}.
        /// </summary>
        public static readonly Guid ConductingRiskSelectEmployeeTypeID = new Guid(0x9317fde2, 0xaa52, 0x4b0a, 0xb4, 0x7b, 0x12, 0x55, 0x83, 0xe8, 0x53, 0x47); //41

        /// <summary>
        /// Task type name for "ConductingRiskSelectEmployee".
        /// </summary>
        public const string ConductingRiskSelectEmployeeTypeName = "ConductingRiskSelectEmployee";


        /// <summary>
        /// Task type identifier for "ConductingRisk": {1E20961D-1BAC-4AA0-925C-B938590E0987}.
        /// </summary>
        public static readonly Guid ConductingRiskTypeID = new Guid(0x1e20961d, 0x1bac, 0x4aa0, 0x92, 0x5c, 0xb9, 0x38, 0x59, 0x0e, 0x09, 0x87);    //42

        /// <summary>
        /// Task type name for "ConductingRisk".
        /// </summary>
        public const string ConductingRiskTypeName = "ConductingRisk";


        /// <summary>
        /// Task type identifier for "ProcessingRisk": {8D0469F8-F29F-4BE6-9BBF-A58B00F65318}.
        /// </summary>
        public static readonly Guid ProcessingRiskTypeID = new Guid(0x8d0469f8, 0xf29f, 0x4be6, 0x9b, 0xbf, 0xa5, 0x8b, 0x00, 0xf6, 0x53, 0x18);    //43

        /// <summary>
        /// Task type name for "ProcessingRisk".
        /// </summary>
        public const string ProcessingRiskTypeName = "ProcessingRisk";


        /// <summary>
        /// Card type identifier for "WfeSegment": {174E4054-A244-47D6-8ED7-124AC3C65FC0}. Сегмет: МСБ, КОП
        /// </summary>
        public static readonly Guid SegmentTypeID = new Guid(0x174e4054, 0xa244, 0x47d6, 0x8e, 0xd7, 0x12, 0x4a, 0xc3, 0xc6, 0x5f, 0xc0);

        /// <summary>
        /// Card type name for "WfeSegment". Сегмет: МСБ, КОП
        /// </summary>
        public const string SegmentTypeName = "WfeSegment";


        /// <summary>
        /// Task type identifier for "WfeFillingApplication": {4D81F5EC-6D5D-43C4-B7BF-38178A3A5840}.
        /// </summary>
        public static readonly Guid FillingApplicationTypeID = new Guid(0x4d81f5ec, 0x6d5d, 0x43c4, 0xb7, 0xbf, 0x38, 0x17, 0x8a, 0x3a, 0x58, 0x40);

        /// <summary>
        /// Task type name for "WfeFillingApplication".
        /// </summary>
        public const string FillingApplicationTypeName = "WfeFillingApplication";


        /// <summary>
        /// Task type identifier for "WfeRenouncement": {4E81196D-A494-4B23-A7BD-D3C6C2A797E2}.
        /// </summary>
        public static readonly Guid RenouncementTypeID = new Guid(0x4e81196d, 0xa494, 0x4b23, 0xa7, 0xbd, 0xd3, 0xc6, 0xc2, 0xa7, 0x97, 0xe2);

        /// <summary>
        /// Task type name for "WfeRenouncement".
        /// </summary>
        public const string RenouncementTypeName = "WfeRenouncement";


        /// <summary>
        /// Task type identifier for "WfeSelectSalesSupervisor": {3F1AD1D4-48F7-44A8-9EA9-51E0DB155FF6}.
        /// </summary>
        public static readonly Guid SelectSalesSupervisorTypeID = new Guid(0x3f1ad1d4, 0x48f7, 0x44a8, 0x9e, 0xa9, 0x51, 0xe0, 0xdb, 0x15, 0x5f, 0xf6);

        /// <summary>
        /// Task type name for "WfeSelectSalesSupervisor".
        /// </summary>
        public const string SelectSalesSupervisorTypeName = "WfeSelectSalesSupervisor";


        /// <summary>
        /// Task type identifier for "WfeSelectResponsibleKA": {B0B0040D-A8F5-49AD-B0E8-CCEF9F41B603}.
        /// </summary>
        public static readonly Guid SelectResponsibleKATypeID = new Guid(0xb0b0040d, 0xa8f5, 0x49ad, 0xb0, 0xe8, 0xcc, 0xef, 0x9f, 0x41, 0xb6, 0x03);

        /// <summary>
        /// Task type name for "WfeSelectResponsibleKA".
        /// </summary>
        public const string SelectResponsibleKATypeName = "WfeSelectResponsibleKA";

        /// <summary>
        /// Task type identifier for "RequestConsultation": {988BA0C2-1F91-4729-B6E8-C5AFB5A6AC1C}.
        /// </summary>
        public static readonly Guid RequestConsultationTypeID = new Guid(0x988ba0c2, 0x1f91, 0x4729, 0xb6, 0xe8, 0xc5, 0xaf, 0xb5, 0xa6, 0xac, 0x1c);

        /// <summary>
        /// Task type name for "RequestConsultation".
        /// </summary>
        public const string RequestConsultationTypeName = "RequestConsultation";

        /// <summary>
        /// Task type identifier for "ApprovalTransaction": {0FAC46D5-EA1D-499C-81B2-A65030DDB580}.
        /// </summary>
        public static readonly Guid ApprovalTransactionTypeID = new Guid(0x0fac46d5, 0xea1d, 0x499c, 0x81, 0xb2, 0xa6, 0x50, 0x30, 0xdd, 0xb5, 0x80);

        /// <summary>
        /// Task type name for "ApprovalTransaction".
        /// </summary>
        public const string ApprovalTransactionTypeName = "ApprovalTransaction";



        /// <summary>
        /// Task type identifier for "WfeMakingApplicationForKK": {F52A5919-243E-40ED-85FE-798D8E1A7CAA}.
        /// </summary>
        public static readonly Guid MakingApplicationForKKTypeID = new Guid(0xf52a5919, 0x243e, 0x40ed, 0x85, 0xfe, 0x79, 0x8d, 0x8e, 0x1a, 0x7c, 0xaa);

        /// <summary>
        /// Task type name for "WfeMakingApplicationForKK".
        /// </summary>
        public const string MakingApplicationForKKTypeName = "WfeMakingApplicationForKK";


        /// <summary>
        /// Task type identifier for "WfeLoanCommittee": {635610DE-6584-4727-86CE-9164F5F93F86}.
        /// </summary>
        public static readonly Guid LoanCommitteeTypeID = new Guid(0x635610de, 0x6584, 0x4727, 0x86, 0xce, 0x91, 0x64, 0xf5, 0xf9, 0x3f, 0x86);

        /// <summary>
        /// Task type name for "WfeLoanCommittee".
        /// </summary>
        public const string LoanCommitteeTypeName = "WfeLoanCommittee";


        /// <summary>
        /// Task type identifier for "WfePositiveDecision": {C0303A63-68AD-48F6-AB09-4819677F35BD}.
        /// </summary>
        public static readonly Guid PositiveDecisionTypeID = new Guid(0xc0303a63, 0x68ad, 0x48f6, 0xab, 0x09, 0x48, 0x19, 0x67, 0x7f, 0x35, 0xbd);

        /// <summary>
        /// Task type name for "WfePositiveDecision".
        /// </summary>
        public const string PositiveDecisionTypeName = "WfePositiveDecision";


        #endregion

        #region Action Descriptors

        public static readonly WorkflowActionDescriptor WfeLoanSetStateDescriptor =
            new WorkflowActionDescriptor(WfeLoanSetStateActionTypeID)
            {
                Group = "Кредитная заявка",
                Icon = "Thin411"
            };

        #endregion
    }
}
