﻿using System;
using System.Threading.Tasks;
using Tessa.Cards;
using Tessa.Cards.Extensions;
using Tessa.Workflow.Helpful;

namespace Tessa.Extensions.WorkflowExamples.Server.Workflow
{
    public sealed class WfeLoanStoreExtension : CardStoreExtension
    {
        #region Fields

        private readonly Guid startTileID = new Guid(0x755e8f5e, 0xa078, 0x4a19, 0xab, 0x47, 0xd1, 0xae, 0x8e, 0x14, 0x9f, 0x97); // 755e8f5e-a078-4a19-ab47-d1ae8e149f97

        #endregion

        #region Base Overrides

        public override Task BeforeRequest(ICardStoreExtensionContext context)
        {
            if (context.Request.Card.StoreMode == CardStoreMode.Insert)
            {
                context.Request.Info.SetWorkflowTileID(this.startTileID);
                context.Request.Info.SetWorkflowType(WorkflowEngineHelper.WorkflowEngineType);
            }

            return Task.CompletedTask;
        }

        #endregion
    }
}
